use master
GO

set nocount on 

--set to 0 to skip updating the A4Survey_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 1  

declare @ClientPayload01 nvarchar(max) = N'
-- DEV-81278   66462
/* Insert topic data in batch */
IF NOT EXISTS(SELECT 1 FROM sys.types WHERE is_table_type = 1 AND name = ''TopicDataTableType'')
BEGIN
	CREATE TYPE dbo.TopicDataTableType AS TABLE
(
    VariableId INT,
    TopicName NVARCHAR(255),
    PositiveCount INT,
    NegativeCount INT,
    NeutralCount INT
);
END
'

declare @ClientPayload02 nvarchar(max) = N'
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[A4S_sp_BulkInsertSentimentTopicData]'') AND type in (N''P'', N''PC''))
    DROP PROCEDURE [dbo].[A4S_sp_BulkInsertSentimentTopicData]
'

declare @ClientPayload03 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[A4S_sp_BulkInsertSentimentTopicData]     
     @surveyId INT,    
     @topicData dbo.TopicDataTableType READONLY    
AS    
BEGIN    
    DECLARE @schemaName NVARCHAR(40);
    DECLARE @tableName NVARCHAR(255);
    DECLARE @sql NVARCHAR(MAX);

    -- Get schema and table names dynamically based on surveyId
    SET @schemaName = [dbo].GetProjectSchema(@surveyId);
    SET @tableName = @schemaName + ''.[SentimentTopicData]'';

    -- Dynamic SQL for bulk insert
    SET @sql = ''
    MERGE INTO '' + @tableName + '' AS target
    USING @topicData AS source
    ON (target.[Name] = source.TopicName AND target.[ResponseVariableId] = source.VariableId)
    WHEN MATCHED THEN
        UPDATE SET
            target.[PositiveCount] = source.PositiveCount,
            target.[NegativeCount] = source.NegativeCount,
            target.[NeutralCount] = source.NeutralCount
    WHEN NOT MATCHED THEN
        INSERT ([Name], [PositiveCount], [NegativeCount], [NeutralCount], [ResponseVariableId])
        VALUES (source.TopicName, source.PositiveCount, source.NegativeCount, source.NeutralCount, source.VariableId);'';

    -- Execute dynamic SQL
    EXEC sp_executesql @sql, N''@topicData dbo.TopicDataTableType READONLY'', @topicData;
END
'

declare @ClientPayload04 nvarchar(max) = N'
-- DEV-81902   66465
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[A4S_sp_GetSentimentAnalyticsForOpenTextResponses]'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE [dbo].[A4S_sp_GetSentimentAnalyticsForOpenTextResponses]
'

declare @ClientPayload05 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[A4S_sp_GetSentimentAnalyticsForOpenTextResponses]
 @surveyId INT,
 @variableId INT,
 @filter NVARCHAR(MAX),
 @startIndex INT,
 @pageSize INT
AS
BEGIN
 DECLARE @schemaName NVARCHAR(MAX) = [dbo].GetProjectSchema(@surveyId)

 -- The FROM portion that is common to all following queries
 DECLARE @from NVARCHAR(MAX) = 
  '' FROM '' + @schemaName + ''.[SentimentData] sentimentData
     INNER JOIN '' + @schemaName +''.[Respondent] respondent ON sentimentData.[RespondentId] = respondent.[ResRespondent] 

  WHERE sentimentData.[ResponseVariableId] = '' + CONVERT(VARCHAR, @variableId) + '' AND respondent.[ResCompleted]=1''
 
 DECLARE @searchQuery NVARCHAR(MAX) =
  ''SELECT sentimentData.[RespondentId], sentimentData.[ResponseText], sentimentData.[SentimentAnalytics], sentimentData.[AspectAnalytics], sentimentData.[TopicTableAnalytics]'' + @from + @filter + '' ORDER BY [Id]''

 IF @pageSize <> 0
 BEGIN
  SET @searchQuery = @searchQuery + '' OFFSET '' + CONVERT(VARCHAR, @startIndex) + '' ROWS FETCH NEXT '' + CONVERT(VARCHAR, @pageSize) + '' ROWS ONLY''
 END

    DECLARE @totalDisplayedRecordsQuery NVARCHAR(MAX) =
  ''SELECT COUNT(*) AS [TotalDisplayedRecords]'' + @from + @filter
 
    DECLARE @totalRecordsQuery NVARCHAR(MAX) = 
  ''SELECT COUNT(*) AS [TotalRecords]'' + @from

 EXEC sp_executesql  @searchQuery
    EXEC sp_executesql  @totalDisplayedRecordsQuery
 EXEC sp_executesql  @totalRecordsQuery
END
'

--declare @SurveyPayload01 nvarchar(max) = N'waitfor delay ''0:00:01'''

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)
create table #Survey (
	DBName nvarchar(128),
	SchemaName nvarchar(128),
	Processed tinyint default 0
)
create table #SurveyVerif (
	DBName nvarchar(128),
	SchemaName nvarchar(128)
)
create table #SurveysDone (
	DBName nvarchar(128) collate database_default,
	SchemaName nvarchar(128) collate database_default
)
declare @AllDone bit = 0, 
        @TotalClients int, 
		@TotalSurveys int, 
		@ClientCounter int, 
		@SurveyCounter int, 
		@ThisClient nvarchar(128), 
		@ThisSurvey nvarchar(128), 
		@ClientCursor cursor, 
		@SurveyCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalClients = 0, @TotalSurveys = 0, @ClientCounter = 0, @SurveyCounter = 0
	insert into #DB 
	select 'A4Survey_Client_' + cast(Id as nvarchar(16)), 0 from Acuity4.dbo.Client
	     
    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Survey_Client_Template', 0)

	select @TotalClients = count(*) 
	       from #DB
	
	set @ClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @ClientCursor
	fetch next from @ClientCursor into @ThisClient
	while @@FETCH_STATUS = 0 begin
		select @ClientCounter += 1
		select @DBSQL = @ThisClient + N'.sys.sp_executesql'
		select @SQL = N'insert into #Survey select ''' + @ThisClient + ''', SchemaName, 0 from ' + @ThisClient + '.dbo.Survey except select DBName, SchemaName, 0 from #SurveysDone'
		exec @DBSQL @SQL
		select @StatusMessage = 'Updating client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @ClientCounter / @TotalClients
		raiserror (@StatusMessage, 0, 1, @ThisClient, @ClientCounter, @TotalClients, @StatusPercent) with nowait
		
		print 'Client Payload 1'
		select @SQL = replace(replace(@ClientPayload01, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 2'
		select @SQL = replace(replace(@ClientPayload02, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 3'
		select @SQL = replace(replace(@ClientPayload03, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 4'
		select @SQL = replace(replace(@ClientPayload04, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 5'
		select @SQL = replace(replace(@ClientPayload05, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'All Client Payload done for  client ' + @ThisClient + '!'

		update #DB set Processed = 1 where current of @ClientCursor
		fetch next from @ClientCursor into @ThisClient
	end


	close @ClientCursor
	deallocate @ClientCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Survey_Client_Template';
      SET @SQL = 'USE Acuity4;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

    SELECT @AllDone = 1
end



--select * from #DB
--select * from #Survey

drop table #DB
drop table #Survey
drop table #SurveyVerif
drop table #SurveysDone